import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/manual/parts/signes%20and%20rules%20manual/signes/signes_page.dart';
import 'package:road24_mobile/view/manual/parts/signes%20and%20rules%20manual/traffic%20laws/traffic_laws_page.dart';
import 'web_view_of_manual.dart';

class SignesAndRulesManual extends StatefulWidget {
  const SignesAndRulesManual({Key? key}) : super(key: key);

  @override
  _SignesAndRulesManualState createState() => _SignesAndRulesManualState();
}

class _SignesAndRulesManualState extends State<SignesAndRulesManual> {
  late Map<String, Function()?>? paths;
  List<String> imagesPaths = [
    'assets/svg/manual.svg',
    'assets/svg/signes_part.svg',
    'assets/svg/horizontal.svg',
    'assets/svg/vertical.svg',
    'assets/svg/stop.svg',
    'assets/svg/signals_of_ruler.svg',
    'assets/svg/truck.svg',
    'assets/svg/danger.svg',
  ];

  @override
  void initState() {
    if (Config.language == 'ru') {
      paths = {
        "Правила дорожного движения": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => TrafficLawsPage(
                appBarTitle: "Правила дорожного движения",
              ),
            ),
          );
        },
        "Знаки": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => SignesPage(
                appBarTitle: "Знаки",
              ),
            ),
          );
        },
        "Горизонтальная разметка": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) =>
                  // MDViewOfManual(
                  //   appBarTitle: 'Demo',
                  //   content: """
                  //   gg\n![](http://68.183.212.82/assets/b012629f-18f3-4a55-b54f-3793a71daeef)##
                  //   _The Last Markdown Editor, Ever_\n\n[![N|Solid](https://cldup.com/dTxpPi9lDf.thumb.png)]
                  //   (https://nodesource.com/products/nsolid)\n\n[![Build Status](https://travis-ci.org/joemccann/dillinger.svg?branch=master)]
                  //   (https://travis-ci.org/joemccann/dillinger)\n\nDillinger is a cloud-enabled, mobile-ready, offline-storage compatible,\nAngularJS-powered HTML5 Markdown editor.\n\n- Type some Markdown on the left\n- See HTML in the right\n- ✨Magic ✨\n\n## Features\n\n- Import a HTML file and watch it magically convert to Markdown\n- Drag and drop images (requires your Dropbox account be linked)\n- Import and save files from GitHub, Dropbox, Google Drive and One Drive\n- Drag and drop markdown and HTML files into Dillinger\n- Export documents as Markdown, HTML and PDF\n\nMarkdown is a lightweight markup language based on the formatting conventions\nthat people naturally use in email.\nAs [John Gruber] writes on the [Markdown site][df1]\n\n> The overriding design goal for Markdown's\n> formatting syntax is to make it as readable\n> as possible. The idea is that a\n> Markdown-formatted document should be\n> publishable as-is, as plain text, without\n> looking like it's been marked up with tags\n> or formatting instructions.\n\nThis text you see here is *actually- written in Markdown! To get a feel\nfor Markdown's syntax, type some text into the left window and\nwatch the results in the right.\n\n## Tech\n\nDillinger uses a number of open source projects to work properly:\n\n- [AngularJS] - HTML enhanced for web apps!\n- [Ace Editor] - awesome web-based text editor\n- [markdown-it] - Markdown parser done right. Fast and easy to extend.\n- [Twitter Bootstrap] - great UI boilerplate for modern web apps\n- [node.js] - evented I/O for the backend\n- [Express] - fast node.js network app framework [@tjholowaychuk]\n- [Gulp] - the streaming build system\n- [Breakdance](https://breakdance.github.io/breakdance/) - HTML\nto Markdown converter\n- [jQuery] - duh\n\nAnd of course Dillinger itself is open source with a [public repository][dill]\n on GitHub.\n\n## Installation\n\nDillinger requires [Node.js](https://nodejs.org/) v10+ to run.\n\nInstall the dependencies and devDependencies and start the server.\n\n```sh\ncd dillinger\nnpm i\nnode app\n```\n\nFor production environments...\n\n```sh\nnpm install --production\nNODE_ENV=production node app\n```\n\n## Plugins\n\nDillinger is currently extended with the following plugins.\nInstructions on how to use them in your own application are linked below.\n\n| Plugin | README |\n| ------ | ------ |\n| Dropbox | [plugins/dropbox/README.md][PlDb] |\n| GitHub | [plugins/github/README.md][PlGh] |\n| Google Drive | [plugins/googledrive/README.md][PlGd] |\n| OneDrive | [plugins/onedrive/README.md][PlOd] |\n| Medium | [plugins/medium/README.md][PlMe] |\n| Google Analytics | [plugins/googleanalytics/README.md][PlGa] |\n\n## Development\n\nWant to contribute? Great!\n\nDillinger uses Gulp + Webpack for fast developing.\nMake a change in your file and instantaneously see your updates!\n\nOpen your favorite Terminal and run these commands.\n\nFirst Tab:\n\n```sh\nnode app\n```\n\nSecond Tab:\n\n```sh\ngulp watch\n```\n\n(optional) Third:\n\n```sh\nkarma test\n```\n\n#### Building for source\n\nFor production release:\n\n```sh\ngulp build --prod\n```\n\nGenerating pre-built zip archives for distribution:\n\n```sh\ngulp build dist --prod\n```\n\n## Docker\n\nDillinger is very easy to install and deploy in a Docker container.\n\nBy default, the Docker will expose port 8080, so change this within the\nDockerfile if necessary. When ready, simply use the Dockerfile to\nbuild the image.\n\n```sh\ncd dillinger\ndocker build -t <youruser>/dillinger:\${package.json.version} .\n```\n\nThis will create the dillinger image and pull in the necessary dependencies.\nBe sure to swap out `\${package.json.version}` with the actual\nversion of Dillinger.\n\nOnce done, run the Docker image and map the port to whatever you wish on\nyour host. In this example, we simply map port 8000 of the host to\nport 8080 of the Docker (or whatever port was exposed in the Dockerfile):\n\n```sh\ndocker run -d -p 8000:8080 --restart=always --cap-add=SYS_ADMIN --name=dillinger <youruser>/dillinger:\${package.json.version}\n```\n\n> Note: `--capt-add=SYS-ADMIN` is required for PDF rendering.\n\nVerify the deployment by navigating to your server address in\nyour preferred browser.\n\n```sh\n127.0.0.1:8000\n```\n\n## License\n\nMIT\n\n**Free Software, Hell Yeah!**\n\n[//]: # (These are reference links used in the body of this note and get stripped out when the markdown processor does its job. There is no need to format nicely because it shouldn't be seen. Thanks SO - http://stackoverflow.com/questions/4823468/store-comments-in-markdown-syntax)\n\n   [dill]: <https://github.com/joemccann/dillinger>\n   [git-repo-url]: <https://github.com/joemccann/dillinger.git>\n   [john gruber]: <http://daringfireball.net>\n   [df1]: <http://daringfireball.net/projects/markdown/>\n   [markdown-it]: <https://github.com/markdown-it/markdown-it>\n   [Ace Editor]: <http://ace.ajax.org>\n   [node.js]: <http://nodejs.org>\n   [Twitter Bootstrap]: <http://twitter.github.com/bootstrap/>\n   [jQuery]: <http://jquery.com>\n   [@tjholowaychuk]: <http://twitter.com/tjholowaychuk>\n   [express]: <http://expressjs.com>\n   [AngularJS]: <http://angularjs.org>\n   [Gulp]: <http://gulpjs.com>\n\n   [PlDb]: <https://github.com/joemccann/dillinger/tree/master/plugins/dropbox/README.md>\n   [PlGh]: <https://github.com/joemccann/dillinger/tree/master/plugins/github/README.md>\n   [PlGd]: <https://github.com/joemccann/dillinger/tree/master/plugins/googledrive/README.md>\n   [PlOd]: <https://github.com/joemccann/dillinger/tree/master/plugins/onedrive/README.md>\n   [PlMe]: <https://github.com/joemccann/dillinger/tree/master/plugins/medium/README.md>\n   [PlGa]: <https://github.com/RahulHP/dillinger/blob/master/plugins/googleanalytics/README.md>\n
                  // """,
                  // )
                  WebViewOfManual(
                appBarTitle: "Горизонтальная разметка",
                pathOfHTML: "3_Gorizontalnaya_razmetka/Horizontal.html",
              ),
            ),
          );
        },
        "Вертикальная разметка": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Вертикальная разметка",
                pathOfHTML: "4_Vertikalnaya_razmetka/Vertikal_razmetka.html",
              ),
            ),
          );
        },
        "Запрет эксплуатации": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Запрет эксплуатации",
                pathOfHTML: "5_Zapret_Ekspluatacii/Zapret_na_ekspluataciu.html",
              ),
            ),
          );
        },
        "Сигналы регулировщика": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Сигналы регулировщика",
                pathOfHTML:
                    "6_Signali_regulirovshika/Signali-regulirovshika.html",
              ),
            ),
          );
        },
        "Перевозка грузов": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Перевозка грузов",
                pathOfHTML: "7_Perevozka_Gruzov/27_perevozka_gruzov.html",
              ),
            ),
          );
        },
        "Знаки опасности": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Знаки опасности",
                pathOfHTML: "8_Znaki_opasnosti_gruzov/Znaki_opasnosti.html",
              ),
            ),
          );
        },
      };
    } else if (Config.language == 'uz') {
      paths = {
        "Йўл ҳаракати қоидалари": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => TrafficLawsPage(
                appBarTitle: "Йўл ҳаракати қоидалари",
              ),
            ),
          );
        },
        "Белгилар": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => SignesPage(
                appBarTitle: "Белгилар",
              ),
            ),
          );
        },
        "Ётиқ чизиқлар": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Ётиқ чизиқлар",
                pathOfHTML: "3_Gorizontalnaya_razmetka/Horizontal_UZ.html",
              ),
            ),
          );
        },
        "Тик чизиқлар": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Тик чизиқлар",
                pathOfHTML: "4_Vertikalnaya_razmetka/Vertikal_razmetka_UZ.html",
              ),
            ),
          );
        },
        "Фойдаланишни тақиқлаш": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Фойдаланишни тақиқлаш",
                pathOfHTML:
                    "5_Zapret_Ekspluatacii/Zapret_na_ekspluataciu_UZ.html",
              ),
            ),
          );
        },
        "Тартибга солиш сигналлари": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Тартибга солиш сигналлари",
                pathOfHTML:
                    "6_Signali_regulirovshika/Signali-regulirovshika_UZ.html",
              ),
            ),
          );
        },
        "Юк ташиш": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Юк ташиш",
                pathOfHTML: "7_Perevozka_Gruzov/27_perevozka_gruzov_UZ.html",
              ),
            ),
          );
        },
        "Хавф белгилари": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Хавф белгилари",
                pathOfHTML: "8_Znaki_opasnosti_gruzov/Znaki_opasnosti_UZ.html",
              ),
            ),
          );
        },
      };
    } else if (Config.language == 'oz') {
      paths = {
        "Yo'l harakati qoidalari": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => TrafficLawsPage(
                appBarTitle: "Yo'l harakati qoidalari",
              ),
            ),
          );
        },
        "Belgilar": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => SignesPage(
                appBarTitle: "Belgilar",
              ),
            ),
          );
        },
        "Yotiq chiziqlar": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Yotiq chiziqlar",
                pathOfHTML: "3_Gorizontalnaya_razmetka/Horizontal_UZ.html",
              ),
            ),
          );
        },
        "Tik chiziqlar": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Tik chiziqlar",
                pathOfHTML: "4_Vertikalnaya_razmetka/Vertikal_razmetka_UZ.html",
              ),
            ),
          );
        },
        "Foydalanishni taqiqlash": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Foydalanishni taqiqlash",
                pathOfHTML:
                    "5_Zapret_Ekspluatacii/Zapret_na_ekspluataciu_UZ.html",
              ),
            ),
          );
        },
        "Tartibga solish signallari": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Tartibga solish signallari",
                pathOfHTML:
                    "6_Signali_regulirovshika/Signali-regulirovshika_UZ.html",
              ),
            ),
          );
        },
        "Yuk tashish": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Yuk tashish",
                pathOfHTML: "7_Perevozka_Gruzov/27_perevozka_gruzov_UZ.html",
              ),
            ),
          );
        },
        "Xavf belgilari": () {
          Navigator.push(
            context,
            CupertinoPageRoute(
              builder: (context) => WebViewOfManual(
                appBarTitle: "Xavf belgilari",
                pathOfHTML: "8_Znaki_opasnosti_gruzov/Znaki_opasnosti_UZ.html",
              ),
            ),
          );
        },
      };
    }
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.appPrimaryColor,
      appBar: appBar(context),
      body: ListView(
        shrinkWrap: true,
        padding: const EdgeInsets.symmetric(horizontal: 16.0),
        children: List.generate(
          paths!.length,
          (index) => Column(
            children: [
              InkWell(
                onTap: paths!.values.toList()[index],
                child: Container(
                  height: 68.0,
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Container(
                        height: 40.0,
                        width: 40.0,
                        padding: const EdgeInsets.all(7.0),
                        margin: const EdgeInsets.symmetric(horizontal: 10.0),
                        decoration: BoxDecoration(
                          shape: BoxShape.circle,
                          color: Color(0xff767680).withOpacity(0.12),
                        ),
                        child: SvgPicture.asset(imagesPaths[index]),
                      ),
                      Expanded(
                        child: Text(
                          paths!.keys.toList()[index],
                          maxLines: 2,
                          textAlign: TextAlign.start,
                          overflow: TextOverflow.ellipsis,
                          style: AppStyle.textStyle().copyWith(
                              color: Color(0xff282828),
                              fontWeight: FontWeight.w400,
                              fontSize: 16.0),
                        ),
                      ),
                      const Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 8.0),
                        child: Icon(
                          Icons.chevron_right,
                          color: AppColors.unSelectedColor,
                        ),
                      ),
                    ],
                  ),
                ),
              ),
              (index != paths!.length - 1)
                  ? const Divider(
                      height: 1.0,
                      color: Color(0XFFCACACA),
                    )
                  : const SizedBox(
                      height: 60.0,
                    )
            ],
          ),
        ),
      ),
    );
  }

  AppBar appBar(BuildContext context) {
    return AppBar(
      toolbarHeight: 60.0,
      leading: Material(
        type: MaterialType.transparency,
        child: InkWell(
          onTap: () {
            Navigator.pop(context);
          },
          child: Container(
            margin: const EdgeInsets.all(10.0),
            decoration: const BoxDecoration(
              color: Color(0xffDFDFDF),
              shape: BoxShape.circle,
            ),
            child: const Center(
              child: Icon(
                Icons.arrow_back_ios_outlined,
                size: 20.0,
                color: Colors.black,
              ),
            ),
          ),
        ),
      ),
      title: Text(
        S.of(context).manual_signes_and_rules,
        style: AppStyle.textStyle().copyWith(
            color: Colors.black, fontWeight: FontWeight.w600, fontSize: 21.0),
        maxLines: 2,
        textAlign: TextAlign.center,
      ),
    );
  }
}
